#version 140
#extension GL_EXT_gpu_shader4 : enable
// SymmetricVisionLike KaleidoscopeMod01.fsh  by  meistermayo
//https://www.shadertoy.com/view/7l2cDW
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;

    float segmentCount = 7.;
    
    // polar
    vec2 shiftUV = uv - 0.5;
    float radius = length(shiftUV);
    float angle = atan(shiftUV.y, shiftUV.x);
    
    float segmentAngle = (3.14*2.) / segmentCount;
    
    angle -= segmentAngle * floor(angle / segmentAngle);
    
    angle = min(angle, segmentAngle - angle);
    
    // back to car
    vec2 cartUV = vec2(cos(angle), sin(angle)) * radius + 0.5;
    
    /// ??? 
    cartUV = max(min(cartUV, 2.0 - cartUV), -cartUV);

    //rot
    float _t = iTime*0.025;
    mat2 rot = mat2( cos(_t), sin(_t), -sin(_t), cos(_t));

    float radSin = sin(radius*10.+iTime*8.)*0.01;
    cartUV *= 1.+radSin;
    
    // Time varying pixel color
    vec4 col = texture2D(iChannel0, cartUV*1.*rot + vec2(sin(iTime)+iTime,cos(iTime)+iTime)*.0125);

    // Output to screen
    vec4 lutcol = texture2D(iChannel1, vec2(col.x, col.y+col.z) + vec2(sin(iTime),iTime)*0.1);
    lutcol *= 1.5+(radSin*10.);

    gl_FragColor = lutcol;
}